DROP VIEW basis_view;

CREATE OR REPLACE VIEW basis_view AS 
 SELECT b.id, b.naam AS plannaam, g.naam AS gemeente, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 1 AND bv.bouwplanid = b.id) AS voortgang, b.prognose_oplevering AS oplevering, ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND factmetperiode.factsoortid <> 1 AND factmetperiode.factsoortid <> 2 AND factmetperiode.factsoortid <> 19) AS "gepland nieuwbouw", ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND (factmetperiode.factsoortid = 3 OR factmetperiode.factsoortid = 6 OR factmetperiode.factsoortid = 9 OR factmetperiode.factsoortid = 4 OR factmetperiode.factsoortid = 7 OR factmetperiode.factsoortid = 10 OR factmetperiode.factsoortid = 12 OR factmetperiode.factsoortid = 14 OR factmetperiode.factsoortid = 16)) AS "gepland sociaal", ( SELECT sum(factmetperiode.planningaantal) AS sum
           FROM factmetperiode
          WHERE factmetperiode.bouwplanid = b.id AND factmetperiode.factsoortid = 2) AS "gepland sloop"
   FROM bouwplan b
   LEFT JOIN gemeente g ON b.gemeenteid = g.id
   LEFT JOIN statusplanologisch s ON b.statusplanologischid = s.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE basis_view OWNER TO rwbp;

